/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.AbstractListValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.FunctionAnnotationValue;
import carpet.script.value.FunctionUnpackedArgumentsValue;
import carpet.script.value.LContainerValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Operators {
    public static final Map<String, Integer> precedence = new HashMap<String, Integer>(){
        {
            this.put("attribute~:", 80);
            this.put("unary+-!...", 60);
            this.put("exponent^", 40);
            this.put("multiplication*/%", 30);
            this.put("addition+-", 20);
            this.put("compare>=><=<", 10);
            this.put("equal==!=", 7);
            this.put("and&&", 5);
            this.put("or||", 4);
            this.put("assign=<>", 3);
            this.put("def->", 2);
            this.put("nextop;", 1);
        }
    };

    public static void apply(Expression expression) {
        expression.addBinaryOperator("+", precedence.get("addition+-"), true, Value::add);
        expression.addFunction("sum", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            Value accumulator = (Value)lv.get(0);
            for (Value v : lv.subList(1, size)) {
                accumulator = accumulator.add(v);
            }
            return accumulator;
        });
        expression.addFunctionalEquivalence("+", "sum");
        expression.addBinaryOperator("-", precedence.get("addition+-"), true, Value::subtract);
        expression.addFunction("difference", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            Value accumulator = (Value)lv.get(0);
            for (Value v : lv.subList(1, size)) {
                accumulator = accumulator.subtract(v);
            }
            return accumulator;
        });
        expression.addFunctionalEquivalence("-", "difference");
        expression.addBinaryOperator("*", precedence.get("multiplication*/%"), true, Value::multiply);
        expression.addFunction("product", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            Value accumulator = (Value)lv.get(0);
            for (Value v : lv.subList(1, size)) {
                accumulator = accumulator.multiply(v);
            }
            return accumulator;
        });
        expression.addFunctionalEquivalence("*", "product");
        expression.addBinaryOperator("/", precedence.get("multiplication*/%"), true, Value::divide);
        expression.addFunction("quotient", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            Value accumulator = (Value)lv.get(0);
            for (Value v : lv.subList(1, size)) {
                accumulator = accumulator.divide(v);
            }
            return accumulator;
        });
        expression.addFunctionalEquivalence("/", "quotient");
        expression.addBinaryOperator("%", precedence.get("multiplication*/%"), true, (v1, v2) -> NumericValue.asNumber(v1).mod(NumericValue.asNumber(v2)));
        expression.addBinaryOperator("^", precedence.get("exponent^"), false, (v1, v2) -> new NumericValue(Math.pow(NumericValue.asNumber(v1).getDouble(), NumericValue.asNumber(v2).getDouble())));
        expression.addFunction("bitwise_and", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            long accumulator = NumericValue.asNumber((Value)lv.get(0)).getLong();
            for (Value v : lv.subList(1, size)) {
                accumulator &= NumericValue.asNumber(v).getLong();
            }
            return new NumericValue(accumulator);
        });
        expression.addFunction("bitwise_xor", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            long accumulator = NumericValue.asNumber((Value)lv.get(0)).getLong();
            for (Value v : lv.subList(1, size)) {
                accumulator ^= NumericValue.asNumber(v).getLong();
            }
            return new NumericValue(accumulator);
        });
        expression.addFunction("bitwise_or", lv -> {
            int size = lv.size();
            if (size == 0) {
                return Value.NULL;
            }
            long accumulator = NumericValue.asNumber((Value)lv.get(0)).getLong();
            for (Value v : lv.subList(1, size)) {
                accumulator |= NumericValue.asNumber(v).getLong();
            }
            return new NumericValue(accumulator);
        });
        expression.addLazyBinaryOperator("&&", precedence.get("and&&"), false, true, t -> Context.Type.BOOLEAN, (c, t, lv1, lv2) -> {
            Value v1 = lv1.evalValue((Context)c, Context.BOOLEAN);
            return v1.getBoolean() ? lv2 : (cc, tt) -> v1;
        });
        expression.addPureLazyFunction("and", -1, t -> Context.Type.BOOLEAN, (c, t, lv) -> {
            int last = lv.size() - 1;
            if (last == -1) {
                return LazyValue.TRUE;
            }
            for (LazyValue l : lv.subList(0, last)) {
                Value val = l.evalValue((Context)c, Context.Type.BOOLEAN);
                if (val instanceof FunctionUnpackedArgumentsValue) {
                    FunctionUnpackedArgumentsValue fuav = (FunctionUnpackedArgumentsValue)val;
                    for (Value it : fuav) {
                        if (it.getBoolean()) continue;
                        return (cc, tt) -> it;
                    }
                    continue;
                }
                if (val.getBoolean()) continue;
                return (cc, tt) -> val;
            }
            return (LazyValue)lv.get(last);
        });
        expression.addFunctionalEquivalence("&&", "and");
        expression.addLazyBinaryOperator("||", precedence.get("or||"), false, true, t -> Context.Type.BOOLEAN, (c, t, lv1, lv2) -> {
            Value v1 = lv1.evalValue((Context)c, Context.BOOLEAN);
            return v1.getBoolean() ? (cc, tt) -> v1 : lv2;
        });
        expression.addPureLazyFunction("or", -1, t -> Context.Type.BOOLEAN, (c, t, lv) -> {
            int last = lv.size() - 1;
            if (last == -1) {
                return LazyValue.FALSE;
            }
            for (LazyValue l : lv.subList(0, last)) {
                Value val = l.evalValue((Context)c, Context.Type.BOOLEAN);
                if (val instanceof FunctionUnpackedArgumentsValue) {
                    FunctionUnpackedArgumentsValue fuav = (FunctionUnpackedArgumentsValue)val;
                    for (Value it : fuav) {
                        if (!it.getBoolean()) continue;
                        return (cc, tt) -> it;
                    }
                    continue;
                }
                if (!val.getBoolean()) continue;
                return (cc, tt) -> val;
            }
            return (LazyValue)lv.get(last);
        });
        expression.addFunctionalEquivalence("||", "or");
        expression.addBinaryOperator("~", precedence.get("attribute~:"), true, Value::in);
        expression.addBinaryOperator(">", precedence.get("compare>=><=<"), false, (v1, v2) -> BooleanValue.of(v1.compareTo((Value)v2) > 0));
        expression.addFunction("decreasing", lv -> {
            int size = lv.size();
            if (size < 2) {
                return Value.TRUE;
            }
            Value prev = (Value)lv.get(0);
            for (Value next : lv.subList(1, size)) {
                if (prev.compareTo(next) <= 0) {
                    return Value.FALSE;
                }
                prev = next;
            }
            return Value.TRUE;
        });
        expression.addFunctionalEquivalence(">", "decreasing");
        expression.addBinaryOperator(">=", precedence.get("compare>=><=<"), false, (v1, v2) -> BooleanValue.of(v1.compareTo((Value)v2) >= 0));
        expression.addFunction("nonincreasing", lv -> {
            int size = lv.size();
            if (size < 2) {
                return Value.TRUE;
            }
            Value prev = (Value)lv.get(0);
            for (Value next : lv.subList(1, size)) {
                if (prev.compareTo(next) < 0) {
                    return Value.FALSE;
                }
                prev = next;
            }
            return Value.TRUE;
        });
        expression.addFunctionalEquivalence(">=", "nonincreasing");
        expression.addBinaryOperator("<", precedence.get("compare>=><=<"), false, (v1, v2) -> BooleanValue.of(v1.compareTo((Value)v2) < 0));
        expression.addFunction("increasing", lv -> {
            int size = lv.size();
            if (size < 2) {
                return Value.TRUE;
            }
            Value prev = (Value)lv.get(0);
            for (Value next : lv.subList(1, size)) {
                if (prev.compareTo(next) >= 0) {
                    return Value.FALSE;
                }
                prev = next;
            }
            return Value.TRUE;
        });
        expression.addFunctionalEquivalence("<", "increasing");
        expression.addBinaryOperator("<=", precedence.get("compare>=><=<"), false, (v1, v2) -> BooleanValue.of(v1.compareTo((Value)v2) <= 0));
        expression.addFunction("nondecreasing", lv -> {
            int size = lv.size();
            if (size < 2) {
                return Value.TRUE;
            }
            Value prev = (Value)lv.get(0);
            for (Value next : lv.subList(1, size)) {
                if (prev.compareTo(next) > 0) {
                    return Value.FALSE;
                }
                prev = next;
            }
            return Value.TRUE;
        });
        expression.addFunctionalEquivalence("<=", "nondecreasing");
        expression.addMathematicalBinaryIntFunction("bitwise_shift_left", (num, amount) -> num << (int)amount);
        expression.addMathematicalBinaryIntFunction("bitwise_shift_right", (num, amount) -> num >>> (int)amount);
        expression.addMathematicalBinaryIntFunction("bitwise_arithmetic_shift_right", (num, amount) -> num >> (int)amount);
        expression.addMathematicalBinaryIntFunction("bitwise_roll_left", (num, amount) -> Long.rotateLeft(num, (int)amount));
        expression.addMathematicalBinaryIntFunction("bitwise_roll_right", (num, amount) -> Long.rotateRight(num, (int)amount));
        expression.addMathematicalUnaryIntFunction("bitwise_not", d -> {
            long num = (long)d;
            return num ^ 0xFFFFFFFFFFFFFFFFL;
        });
        expression.addMathematicalUnaryIntFunction("bitwise_popcount", d -> Long.bitCount((long)d));
        expression.addMathematicalUnaryIntFunction("double_to_long_bits", Double::doubleToLongBits);
        expression.addUnaryFunction("long_to_double_bits", v -> new NumericValue(Double.longBitsToDouble(NumericValue.asNumber(v).getLong())));
        expression.addBinaryOperator("==", precedence.get("equal==!="), false, (v1, v2) -> v1.equals(v2) ? Value.TRUE : Value.FALSE);
        expression.addFunction("equal", lv -> {
            int size = lv.size();
            if (size < 2) {
                return Value.TRUE;
            }
            Value prev = (Value)lv.get(0);
            for (Value next : lv.subList(1, size)) {
                if (!prev.equals(next)) {
                    return Value.FALSE;
                }
                prev = next;
            }
            return Value.TRUE;
        });
        expression.addFunctionalEquivalence("==", "equal");
        expression.addBinaryOperator("!=", precedence.get("equal==!="), false, (v1, v2) -> v1.equals(v2) ? Value.FALSE : Value.TRUE);
        expression.addFunction("unique", lv -> {
            int size = lv.size();
            if (size < 2) {
                return Value.TRUE;
            }
            lv.sort(Comparator.comparingInt(Value::hashCode));
            Value prev = (Value)lv.get(0);
            for (Value next : lv.subList(1, size)) {
                if (prev.equals(next)) {
                    return Value.FALSE;
                }
                prev = next;
            }
            return Value.TRUE;
        });
        expression.addFunctionalEquivalence("!=", "unique");
        expression.addLazyBinaryOperator("=", precedence.get("assign=<>"), false, false, t -> Context.Type.LVALUE, (c, t, lv1, lv2) -> {
            Value lcv;
            Value v1 = lv1.evalValue((Context)c, Context.LVALUE);
            Value v2 = lv2.evalValue((Context)c);
            if (v1 instanceof ListValue.ListConstructorValue) {
                lcv = (ListValue.ListConstructorValue)v1;
                if (v2 instanceof ListValue) {
                    ListValue list = (ListValue)v2;
                    List<Value> ll = ((ListValue)lcv).getItems();
                    List<Value> rl = list.getItems();
                    if (ll.size() < rl.size()) {
                        throw new InternalExpressionException("Too many values to unpack");
                    }
                    if (ll.size() > rl.size()) {
                        throw new InternalExpressionException("Too few values to unpack");
                    }
                    for (Value v : ll) {
                        v.assertAssignable();
                    }
                    Iterator<Value> li = ll.iterator();
                    Iterator<Value> ri = rl.iterator();
                    while (li.hasNext()) {
                        String lname = li.next().getVariable();
                        Value vval = ri.next().reboundedTo(lname);
                        expression.setAnyVariable((Context)c, lname, (cc, tt) -> vval);
                    }
                    return (cc, tt) -> Value.TRUE;
                }
            }
            if (v1 instanceof LContainerValue) {
                lcv = (LContainerValue)v1;
                ContainerValueInterface container = ((LContainerValue)lcv).container();
                if (container == null) {
                    return (cc, tt) -> Value.NULL;
                }
                Value address = ((LContainerValue)lcv).address();
                if (!container.put(address, v2)) {
                    return (cc, tt) -> Value.NULL;
                }
                return (cc, tt) -> v2;
            }
            v1.assertAssignable();
            String varname = v1.getVariable();
            Value copy = v2.reboundedTo(varname);
            LazyValue boundedLHS = (cc, tt) -> copy;
            expression.setAnyVariable((Context)c, varname, boundedLHS);
            return boundedLHS;
        });
        expression.addLazyBinaryOperator("+=", precedence.get("assign=<>"), false, false, t -> Context.Type.LVALUE, (c, t, lv1, lv2) -> {
            LazyValue boundedLHS;
            Value lcv;
            Value v1 = lv1.evalValue((Context)c, Context.LVALUE);
            Value v2 = lv2.evalValue((Context)c);
            if (v1 instanceof ListValue.ListConstructorValue) {
                lcv = (ListValue.ListConstructorValue)v1;
                if (v2 instanceof ListValue) {
                    ListValue list = (ListValue)v2;
                    List<Value> ll = ((ListValue)lcv).getItems();
                    List<Value> rl = list.getItems();
                    if (ll.size() < rl.size()) {
                        throw new InternalExpressionException("Too many values to unpack");
                    }
                    if (ll.size() > rl.size()) {
                        throw new InternalExpressionException("Too few values to unpack");
                    }
                    for (Value v : ll) {
                        v.assertAssignable();
                    }
                    Iterator<Value> li = ll.iterator();
                    Iterator<Value> ri = rl.iterator();
                    while (li.hasNext()) {
                        Value lval = li.next();
                        String lname = lval.getVariable();
                        Value result = lval.add(ri.next()).bindTo(lname);
                        expression.setAnyVariable((Context)c, lname, (cc, tt) -> result);
                    }
                    return (cc, tt) -> Value.TRUE;
                }
            }
            if (v1 instanceof LContainerValue) {
                lcv = (LContainerValue)v1;
                ContainerValueInterface cvi = ((LContainerValue)lcv).container();
                if (cvi == null) {
                    throw new InternalExpressionException("Failed to resolve left hand side of the += operation");
                }
                Value key = ((LContainerValue)lcv).address();
                Value value = cvi.get(key);
                if (value instanceof ListValue || value instanceof MapValue) {
                    ((AbstractListValue)value).append(v2);
                    return (cc, tt) -> value;
                }
                Value res = value.add(v2);
                cvi.put(key, res);
                return (cc, tt) -> res;
            }
            v1.assertAssignable();
            String varname = v1.getVariable();
            if (v1 instanceof ListValue || v1 instanceof MapValue) {
                ((AbstractListValue)v1).append(v2);
                boundedLHS = (cc, tt) -> v1;
            } else {
                Value result = v1.add(v2).bindTo(varname);
                boundedLHS = (cc, tt) -> result;
            }
            expression.setAnyVariable((Context)c, varname, boundedLHS);
            return boundedLHS;
        });
        expression.addBinaryContextOperator("<>", precedence.get("assign=<>"), false, false, false, (c, t, v1, v2) -> {
            if (v1 instanceof ListValue.ListConstructorValue) {
                ListValue.ListConstructorValue lcv1 = (ListValue.ListConstructorValue)v1;
                if (v2 instanceof ListValue.ListConstructorValue) {
                    ListValue.ListConstructorValue lcv2 = (ListValue.ListConstructorValue)v2;
                    List<Value> ll = lcv1.getItems();
                    List<Value> rl = lcv2.getItems();
                    if (ll.size() < rl.size()) {
                        throw new InternalExpressionException("Too many values to unpack");
                    }
                    if (ll.size() > rl.size()) {
                        throw new InternalExpressionException("Too few values to unpack");
                    }
                    for (Value v : ll) {
                        v.assertAssignable();
                    }
                    for (Value v : rl) {
                        v.assertAssignable();
                    }
                    Iterator<Value> li = ll.iterator();
                    Iterator<Value> ri = rl.iterator();
                    while (li.hasNext()) {
                        Value lval = li.next();
                        Value rval = ri.next();
                        String lname = lval.getVariable();
                        String rname = rval.getVariable();
                        lval.reboundedTo(rname);
                        rval.reboundedTo(lname);
                        expression.setAnyVariable((Context)c, lname, (cc, tt) -> rval);
                        expression.setAnyVariable((Context)c, rname, (cc, tt) -> lval);
                    }
                    return Value.TRUE;
                }
            }
            v1.assertAssignable();
            v2.assertAssignable();
            String lvalvar = v1.getVariable();
            String rvalvar = v2.getVariable();
            Value lval = v2.reboundedTo(lvalvar);
            Value rval = v1.reboundedTo(rvalvar);
            expression.setAnyVariable((Context)c, lvalvar, (cc, tt) -> lval);
            expression.setAnyVariable((Context)c, rvalvar, (cc, tt) -> rval);
            return lval;
        });
        expression.addUnaryOperator("-", false, v -> NumericValue.asNumber(v).opposite());
        expression.addUnaryOperator("+", false, NumericValue::asNumber);
        expression.addLazyUnaryOperator("!", precedence.get("unary+-!..."), false, true, x -> Context.Type.BOOLEAN, (c, t, lv) -> lv.evalValue((Context)c, Context.BOOLEAN).getBoolean() ? (cc, tt) -> Value.FALSE : (cc, tt) -> Value.TRUE);
        expression.addLazyUnaryOperator("...", precedence.get("unary+-!..."), false, true, t -> t == Context.Type.LOCALIZATION ? Context.NONE : t, (c, t, lv) -> {
            if (t == Context.LOCALIZATION) {
                return (cc, tt) -> new FunctionAnnotationValue(lv.evalValue((Context)c), FunctionAnnotationValue.Type.VARARG);
            }
            Value patt0$temp = lv.evalValue((Context)c, (Context.Type)((Object)t));
            if (!(patt0$temp instanceof AbstractListValue)) {
                throw new InternalExpressionException("Unable to unpack a non-list");
            }
            AbstractListValue alv = (AbstractListValue)patt0$temp;
            FunctionUnpackedArgumentsValue fuaval = new FunctionUnpackedArgumentsValue(alv.unpack());
            return (cc, tt) -> fuaval;
        });
    }
}

